﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultNetworkPlugin.Controls.Strategy;

namespace WinfootDefaultNetworkPlugin.Controls
{
    public partial class KeepAliveTime : UserControl,IControl,ICorrespondenceOS
    {
        private KeepAliveTimeController keepAliveTimeController;

        public KeepAliveTime()
        {
           InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsSeven
#endif
                                       };
            
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.migiside.net/wiki/doku.php?id=plugin:network:keepalivetime"));
                userHelp.Show();
            }
        }

        public void SetKeepAliveTimeValue(int i)
        {
            textBox1.Text = i.ToString();
        }


        public int GetKeepAliveTimeValue()
        {
            return Convert.ToInt32(textBox1.Text);
        }

        #region IControl メンバ

        public void Apply()
        {
            keepAliveTimeController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return keepAliveTimeController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if ((e.KeyChar < '0' || e.KeyChar > '9') && e.KeyChar != '\b')
            {
                e.Handled = true;
            }

        }

        private void KeepAliveTime_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            keepAliveTimeController = new KeepAliveTimeController(this,
                                                                                      (IKeepAliveTimeStrategy)
                                                                                      wfUtillity.
                                                                                          GetCorrespondenceInstance
                                                                                          (new List<ICorrespondenceOS>
                                                                                               {
                                                                                                   new KeepAliveTimeDefaultStrategy()
                                                                                               }));
            keepAliveTimeController.Read();
        }
    
    }
}
